## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"
    @mark_create_layout
    def my_layout(self):
        nodes = [
            flowui.Node(id="a", data=flowui.NodeData(label="hello"), position=flowui.XYPosition(0, 0)),
            flowui.Node(id="b", type="app", data=flowui.NodeData(component=mui.HBox([
                flowui.NodeResizer().prop(minWidth=100, minHeight=100, maxWidth=300, maxHeight=300),
                mui.Typography("wtf"),
                mui.Button("Test"),
            ]).prop(width="100%", height="100%", minWidth=100, minHeight=100, border="2px solid black", borderRadius="21px", className="node_selected")), position=flowui.XYPosition(300, 0)),
        ]
        return mui.HBox([
            flowui.Flow(nodes, [], [
                flowui.MiniMap(),
                flowui.Controls(),
                flowui.Background().prop(variant="lines", color="#efefef"),
            ])
        ]).prop(width="100%", height="100%", overflow="hidden").update_sx_props({
            ".react-flow__node.selected": {
                ".node_selected:only-child": {
                    "border": "2px solid red",
                }
            }
        })
```

